<?php

use FirstpointCh\Shop\Database\Factories\ChannelFactory;
use FirstpointCh\Shop\Models\Channel;
use FirstpointCh\Shop\Tests\Models\User;
use FirstpointCh\Shop\Tests\TestCase;
use function Pest\Laravel\actingAs;
use function Pest\Laravel\get;

uses(TestCase::class)->in(__DIR__);

uses()
    ->beforeEach(fn () => actingAs(User::factory()->create(), 'cp'))
    ->in('Cp');

uses()
    ->beforeEach(fn () => ChannelFactory::new()->create(['slug' => 'default']))
    ->in(__DIR__);

function datatableSearch($endpoint, $query)
{
    return get($endpoint.'?filters[search]='.urlencode($query));
}

function defaultChannel()
{
    return Channel::where('slug', 'default')->first();
}

// class DatatableAssert
// {
//     public function __construct(
//         public $response
//     ) {
//     }

//     public function assertComponent($component)
//     {
//         $this->response->assertInertia(
//             fn (AssertableInertia $page) => $page->component($component)
//         );

//         return $this;
//     }
// }
