<?php

use FirstpointCh\Shop\Models\Channel;
use FirstpointCh\Shop\Models\Variant;

it('filters active variants', function () {
    $inactive = Variant::factory()->create(['is_active' => false]);
    $active = Variant::factory()->create(['is_active' => true]);

    expect(Variant::get())->toHaveCount(2);
    expect(Variant::active()->get())->toHaveCount(1);
    expect(Variant::active()->first())->toMatchArray(['id' => $active->id]);
});

it('loads the variant price', function () {
    $channel1 = Channel::factory()->create();
    $channel2 = Channel::factory()->create();
    $variant = Variant::factory()->create();

    $variant->channels()->attach($channel1->id, ['price' => 10, 'product_id' => $variant->product_id]);
    $variant->channels()->attach($channel2->id, ['price' => 20, 'product_id' => $variant->product_id]);

    // It takes the current channel if channel aware
    shop()->channelAware();
    shop()->setChannel($channel1);
    expect(Variant::withPrice()->find($variant->id)->price)->toBe(10);

    shop()->setChannel($channel2);
    expect(Variant::withPrice()->find($variant->id)->price)->toBe(20);
});
