<?php

use FirstpointCh\Shop\Models\Channel;
use Inertia\Testing\AssertableInertia;

it('shows the channel index', function () {
    defaultChannel()->delete();

    $channel = Channel::factory()->create();

    $this->get('/cp/channels')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Channel/Index')
            ->has('channels.data', 1)
            ->where('channels.data.0.id', $channel->id)
        );
});

it('searches channels by name', function () {
    $firstChannel = Channel::factory()->create([
        'name' => 'First channel',
    ]);

    $secondChannel = Channel::factory()->create([
        'name' => 'Second channel',
    ]);

    datatableSearch('/cp/channels', 'First channel')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Channel/Index')
            ->has('channels.data', 1)
            ->where('channels.data.0.id', $firstChannel->id)
        );

    datatableSearch('/cp/channels', 'Second channel')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Channel/Index')
            ->has('channels.data', 1)
            ->where('channels.data.0.id', $secondChannel->id)
        );

    datatableSearch('/cp/channels', 'channel')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Channel/Index')
            ->has('channels.data', 2)
        );
});
