<?php

use FirstpointCh\Shop\Models\Channel;
use Inertia\Testing\AssertableInertia;

it('shows the channel edit form', function () {
    $channel = Channel::factory()->create();

    $this->get('/cp/channels/'.$channel->id.'/edit')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Channel/Form')
            ->where('channel.id', $channel->id)
        );
});

test('the name is required', function () {
    $channel = Channel::factory()->create();

    $this->post('/cp/channels/'.$channel->id)->assertStatus(302)->assertSessionHasErrors('name');
});

test('the slug is required', function () {
    $channel = Channel::factory()->create();

    $this->post('/cp/channels/'.$channel->id)->assertStatus(302)->assertSessionHasErrors('slug');
});

test('the currency is required and must have a length of 3 chars', function () {
    $channel = Channel::factory()->create();

    $this->post('/cp/channels/'.$channel->id)->assertStatus(302)->assertSessionHasErrors('currency');
    $this->post('/cp/channels/'.$channel->id, ['currency' => 'test'])->assertStatus(302)->assertSessionHasErrors('currency');
    $this->post('/cp/channels/'.$channel->id, ['currency' => 'tes'])->assertStatus(302)->assertSessionDoesntHaveErrors('currency');
});

test('the currency_format is required', function () {
    $channel = Channel::factory()->create();

    $this->post('/cp/channels/'.$channel->id)->assertStatus(302)->assertSessionHasErrors('currency_format');
});

test('available countries is required', function () {
    $channel = Channel::factory()->create();

    $this->post('/cp/channels/'.$channel->id)->assertStatus(302)->assertSessionHasErrors('available_countries');
});

test('each available country must have a length of 2 chars', function () {
    $channel = Channel::factory()->create();

    $this->post('/cp/channels/'.$channel->id, [
        'available_countries' => ['abc', 'de'],
    ])
    ->assertStatus(302)
    ->assertSessionHasErrors('available_countries.0')
    ->assertSessionDoesntHaveErrors('available_countries.1');
});

it('updates a channel', function () {
    $channel = Channel::factory()->create([
        'name' => 'Name',
        'slug' => 'slug',
        'currency' => 'CHF',
        'currency_format' => 'de_CH',
        'available_countries' => ['CH'],
    ]);

    $data = [
        'name' => 'New name',
        'slug' => 'new-slug',
        'currency' => 'EUR',
        'currency_format' => 'fr_FR',
        'available_countries' => ['FR'],
    ];

    $this->post('/cp/channels/'.$channel->id, $data)
        ->assertStatus(302)
        ->assertRedirect('/cp/channels');

    $data['available_countries'] = json_encode($data['available_countries']);

    $this->assertDatabaseHas('channels', $data);
});
