<?php

use Inertia\Testing\AssertableInertia;

it('shows the channel create form', function () {
    $this->get('/cp/channels/create')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Channel/Form')
        );
});

test('the name is required', function () {
    $this->post('/cp/channels')->assertStatus(302)->assertSessionHasErrors('name');
});

test('the slug is required', function () {
    $this->post('/cp/channels')->assertStatus(302)->assertSessionHasErrors('slug');
});

test('the currency_format is required', function () {
    $this->post('/cp/channels')->assertStatus(302)->assertSessionHasErrors('currency_format');
});

test('the currency is required and must have a length of 3 chars', function () {
    $this->post('/cp/channels')->assertStatus(302)->assertSessionHasErrors('currency');
    $this->post('/cp/channels', ['currency' => 'test'])->assertStatus(302)->assertSessionHasErrors('currency');
    $this->post('/cp/channels', ['currency' => 'tes'])->assertStatus(302)->assertSessionDoesntHaveErrors('currency');
});

test('available countries is required', function () {
    $this->post('/cp/channels')->assertStatus(302)->assertSessionHasErrors('available_countries');
});

test('each available country must have a length of 2 chars', function () {
    $this->post('/cp/channels', [
        'available_countries' => ['abc', 'de'],
    ])
    ->assertStatus(302)
    ->assertSessionHasErrors('available_countries.0')
    ->assertSessionDoesntHaveErrors('available_countries.1');
});

it('stores a new channel', function () {
    $data = [
        'name' => 'My channel',
        'slug' => 'my-channel',
        'currency' => 'CHF',
        'currency_format' => 'de_CH',
        'available_countries' => ['CH', 'FR'],
    ];

    $this->post('/cp/channels', $data)
        ->assertStatus(302)
        ->assertRedirect('/cp/channels');

    $data['available_countries'] = json_encode($data['available_countries']);

    $this->assertDatabaseHas('channels', $data);
});
