<?php

namespace FirstpointCh\Shop;

use FirstpointCh\Shop\Models\Channel;

class Shop
{
    protected ?Channel $currentChannel;

    protected $channelAware = false;

    public function __construct(string $channel)
    {
        $this->currentChannel = Channel::where('slug', $channel)->first();
    }

    public function getChannel(): ?Channel
    {
        return $this->currentChannel;
    }

    public function setChannel($channel)
    {
        if ($channel instanceof Channel) {
            $this->currentChannel = $channel;
        } elseif (is_string($channel) && $channel) {
            if ($channel === $this->currentChannel->slug) {
                return;
            }

            $this->currentChannel = Channel::where('slug', $channel)->first();

            if (empty($this->currentChannel)) {
                throw new \Exception('Invalid channel "'.$channel.'"');
            }
        } elseif (is_int($channel)) {
            $this->currentChannel = Channel::find($channel);
        } else {
            throw new \Exception('Invalid channel "'.$channel.'"');
        }
    }

    public function isChannelAware()
    {
        return $this->channelAware;
    }

    public function channelAware($value = true)
    {
        $this->channelAware = $value;

        return $this;
    }
}
