<?php

namespace FirstpointCh\Shop\Payment\Gateway;

use Illuminate\Http\Request;
use FirstpointCh\Shop\Exceptions\PaymentDoesNotExist;
use FirstpointCh\Shop\Models\Payment;
use FirstpointCh\Shop\Payment\Enums\GatewayStatus;

class BankTransferGateway extends PaymentGateway
{
    public function init(Payment $payment)
    {
        return redirect()
            ->route('shop::payment.handle', [
                'gateway' => 'bank-transfer',
                'reference' => $payment->reference,
            ]);
    }

    public static function getPaymentIntent(Request $request): Payment
    {
        $payment = customer()->payments()->where('reference', request('reference'))->first();

        if (empty($payment)) {
            throw new PaymentDoesNotExist();
        }

        return $payment;
    }

    public function handle(): GatewayStatus
    {
        return GatewayStatus::Success;
    }
}
