<?php

namespace FirstpointCh\Shop\Payment;

use FirstpointCh\Shop\Actions\Action;
use FirstpointCh\Shop\Models\Order;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class CreatePaymentIntentAction
{
    use Action;

    public function handle(Order $order)
    {
        return DB::transaction(function () use ($order) {
            // Cancel previous payment
            $order->payments()->where('status', 'pending')->update([
                'status' => 'cancelled',
            ]);

            // Create new payment
            return $order->payments()->create([
                'customer_id' => $order->customer_id,
                'reference' => Str::upper(Str::random(15)), // TODO: Generate unique reference
                'gateway' => $order->payment_method,
                'amount' => $order->totalAmount(),
                'currency' => $order->currency,
                'status' => 'pending',
            ]);
        });
    }
}
