<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Translatable\Casts\Localized;
use FirstpointCh\Translatable\Traits\Translatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShippingMethod extends Model
{
    use HasFactory, Translatable;

    protected $guarded = [];

    protected $casts = [
        'name' => Localized::class,
        'description' => Localized::class,
    ];

    protected static function booted()
    {
        static::addGlobalScope('channel-aware', function ($builder) {
            $builder->when(shop()->isChannelAware(), function ($query) {
                $query->whereRelation('channels', 'channel_id', shop()->getChannel()->id);
            });
        });
    }

    public function channels()
    {
        return $this->belongsToMany(Channel::class)
            ->withPivot('price');
    }
}
