<?php

namespace FirstpointCh\Shop\Models;

use Illuminate\Database\Eloquent\Model;

class Price extends Model
{
    protected $table = 'channel_variant';

    protected $guarded = [];

    protected $casts = [
        'price' => 'decimal:2',
    ];

    protected static function booted()
    {
        static::addGlobalScope('channel-aware', function ($builder) {
            $builder->when(shop()->isChannelAware(), function ($query) {
                $query->where('channel_id', shop()->getChannel()->id);
            });
        });
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function channel()
    {
        return $this->belongsTo(Channel::class);
    }
}
