<?php

namespace FirstpointCh\Shop\Http\Requests;

use Illuminate\Database\Eloquent\Builder;

class DatatableRequest
{
    private $searchable = [];

    public function searchable(array $searchable)
    {
        $this->searchable = $searchable;

        return $this;
    }

    public function performQuery(Builder $query)
    {
        if ($q = request('filters.search')) {
            $query->where(function (Builder $query) use ($q) {
                foreach ($this->searchable as $column) {
                    $query->orWhere($column, 'like', "%{$q}%");
                }
            });
        }

        if ($sortColumn = request('sort.column')) {
            $query->orderBy($sortColumn, request('sort.direction'));
        } else {
            $query->orderBy('id', 'desc');
        }

        return $query->paginate(request('perPage', 10), ['*'], 'page');
    }

    public function getState()
    {
        $state = request()->only(['filters', 'sort', 'page', 'perPage']);

        return ! empty($state) ? $state : null;
    }
}
