<?php

namespace FirstpointCh\Shop\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class ChannelAware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next, $channelSlug = null)
    {
        $channelSlug = $channelSlug ?? config('shop.default_channel');

        if (! empty($channelSlug)) {
            shop()->setChannel($channelSlug);
        }

        shop()->channelAware(true);

        return $next($request);
    }
}
