<?php

namespace FirstpointCh\Shop\Http\Controllers;

use FirstpointCh\Shop\Exceptions\PaymentDoesNotExist;
use FirstpointCh\Shop\Order\Enums\OrderStatus;
use FirstpointCh\Shop\Payment\Enums\GatewayStatus;
use FirstpointCh\Shop\Payment\Gateway;
use Illuminate\Http\Request;

class HandlePaymentController extends Controller
{
    public function __invoke($gateway, Request $request)
    {
        $gateway = Gateway::make($gateway);

        try {
            $payment = $gateway->getPaymentIntent($request);
        } catch (PaymentDoesNotExist $e) {
            abort(403);
        }

        switch ($gateway->handle($payment)) {
            case GatewayStatus::Success:
                return redirect(
                    tap(checkout()->data->successUrl, fn ($url) => $payment->success(OrderStatus::Pending))
                )->with([
                    'status' => 'success',
                    'payment' => $payment,
                ]);
            case GatewayStatus::Authorized:
            case GatewayStatus::Charged:
                return redirect(
                    tap(checkout()->data->successUrl, fn ($url) => $payment->success(OrderStatus::Paid))
                )->with([
                    'status' => 'success',
                    'payment' => $payment,
                ]);
            case GatewayStatus::Failed:
                return redirect(
                    tap(checkout()->data->errorUrl, fn ($url) => $payment->failed($gateway->getError()))
                )->with([
                    'status' => 'failed',
                    'payment' => $payment,
                ]);
            case GatewayStatus::Error:
                return redirect(
                    tap(checkout()->data->errorUrl, fn ($url) => $payment->error($gateway->getError()))
                )->with([
                    'status' => 'error',
                    'payment' => $payment,
                ]);
            case GatewayStatus::Unknown:
            default:
                abort(403);
        }
    }
}
