<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use App\Models\User;
use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Http\Requests\DatatableRequest;
use Illuminate\Validation\Rule;
use Inertia\Inertia;

class UserController extends Controller
{
    public function index(DatatableRequest $datatable)
    {
        return Inertia::render('User/Index', [
            'users' => $datatable
                ->searchable(['name', 'email'])
                ->performQuery(
                    User::query()
                ),
            'datatableState' => $datatable->getState(),
        ]);
    }

    public function create()
    {
        return Inertia::render('User/Form');
    }

    public function store()
    {
        User::create(request()->validate([
            'name' => 'required|max:255',
            'email' => 'required|email|unique:users,email',
            'password' => 'required',
        ]));

        return redirect('/cp/users');
    }

    public function edit(User $user)
    {
        return Inertia::render('User/Form', [
            'user' => $user,
        ]);
    }

    public function update(User $user)
    {
        $data = request()->validate([
            'name' => 'required|max:255',
            'email' => [
                'required',
                'email',
                Rule::unique('users')->ignore($user->id),
            ],
            'password' => 'nullable',
        ]);

        if (empty($data['password'])) {
            unset($data['password']);
        }

        $user->update($data);

        return redirect('/cp/users');
    }
}
