<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Models\Product;
use Illuminate\Support\Arr;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

class ProductMediaController extends Controller
{
    public function store(Product $product)
    {
        $data = request()->validate([
            'library' => 'required',
            'files' => 'required|array',
            'files.*' => 'file',
        ]);

        foreach ($data['files'] as $file) {
            /** @var \Illuminate\Http\UploadedFile $file */
            $name = str(
                pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME)
            )->slug();

            $product
                ->addMedia($file)
                ->usingFileName($name)
                ->toMediaCollection($data['library']);
        }

        return redirect('/cp/products/'.$product->id.'/photos');
    }

    public function update(Product $product, Media $media)
    {
        $data = request()->validate([
            'name' => 'required',
            'alt_text' => 'nullable',
        ]);

        $media->setCustomProperty('alt_text', Arr::pull($data, 'alt_text'))
            ->update($data);

        return redirect('/cp/products/'.$product->id.'/photos');
    }

    public function destroy(Product $product, Media $media)
    {
        $media->delete();

        return redirect('/cp/products/'.$product->id.'/photos');
    }
}
