<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Http\Requests\DatatableRequest;
use FirstpointCh\Shop\Models\Channel;
use Inertia\Inertia;

class ChannelController extends Controller
{
    public function index(DatatableRequest $datatable)
    {
        return Inertia::render('Channel/Index', [
            'channels' => $datatable
                ->searchable(['name'])
                ->performQuery(
                    Channel::query()
                ),
            'datatableState' => $datatable->getState(),
        ]);
    }

    public function create()
    {
        return Inertia::render('Channel/Form');
    }

    public function store()
    {
        Channel::create(request()->validate([
            'name' => 'required|max:255',
            'slug' => 'required|max:255',
            'currency' => 'required|size:3',
            'currency_format' => 'required|max:255',
            'available_countries' => 'required|array',
            'available_countries.*' => 'required|size:2',
        ]));

        return redirect('/cp/channels');
    }

    public function edit(Channel $channel)
    {
        return Inertia::render('Channel/Form', [
            'channel' => $channel,
        ]);
    }

    public function update(Channel $channel)
    {
        $channel->update(request()->validate([
            'name' => 'required|max:255',
            'slug' => 'required|max:255',
            'currency' => 'required|size:3',
            'currency_format' => 'required|max:255',
            'available_countries' => 'required|array',
            'available_countries.*' => 'required|size:2',
        ]));

        return redirect('/cp/channels');
    }
}
