<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Http\Requests\DatatableRequest;
use FirstpointCh\Shop\Models\Category;
use Inertia\Inertia;

class CategoryController extends Controller
{
    public function index(DatatableRequest $datatable)
    {
        return Inertia::render('Category/Index', [
            'categories' => $datatable
                ->searchable(['name'])
                ->performQuery(
                    Category::query()
                ),
            'datatableState' => $datatable->getState(),
        ]);
    }

    public function create()
    {
        return Inertia::render('Category/Form');
    }

    public function store()
    {
        Category::create(request()->validate([
            'slug' => 'required',
            'name' => 'required',
            'is_active' => 'required',
        ]));

        return redirect('/cp/categories');
    }

    public function edit(Category $category)
    {
        return Inertia::render('Category/Form', [
            'category' => $category->in('*'),
        ]);
    }

    public function update(Category $category)
    {
        $category->update(request()->validate([
            'slug' => 'required',
            'name' => 'required',
            'is_active' => 'required',
        ]));

        return redirect('/cp/categories');
    }
}
