<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Http\Requests\DatatableRequest;
use FirstpointCh\Shop\Models\Attribute;
use Illuminate\Support\Arr;
use Inertia\Inertia;

class AttributeController extends Controller
{
    public function index(DatatableRequest $datatable)
    {
        return Inertia::render('Attribute/Index', [
            'attributes' => $datatable
                ->searchable(['name'])
                ->performQuery(
                    Attribute::query()
                ),
            'datatableState' => $datatable->getState(),
        ]);
    }

    public function create()
    {
        return Inertia::render('Attribute/Form');
    }

    public function store()
    {
        Attribute::create(request()->validate([
            'key' => 'required|max:255',
            'name' => 'required',
            'type' => 'required',
        ]));

        return redirect('/cp/attributes');
    }

    public function edit(Attribute $attribute)
    {
        $attribute->load('options');
        $attribute->options->map->in('*');

        return Inertia::render('Attribute/Form', [
            'attr' => $attribute->in('*'),
        ]);
    }

    public function update(Attribute $attribute)
    {
        $data = request()->validate([
            'key' => 'required|max:255',
            'name' => 'required',
            'type' => 'required',
            'options' => 'array',
        ]);

        $options = Arr::pull($data, 'options');

        $attribute->update($data);

        foreach ($options as $option) {
            if (! empty($option['id'])) {
                $attribute->options()->find($option['id'])->update($option);
            } else {
                $attribute->options()->create($option);
            }
        }

        return redirect('/cp/attributes');
    }
}
