<?php

namespace FirstpointCh\Shop\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class PublishAssets extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'shop:publish';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Publish assets';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->call('vendor:publish', ['--tag' => 'shop']);

        File::deleteDirectory(public_path('vendor/shop'));

        $this->call('vendor:publish', ['--tag' => 'shop-assets', '--force']);

        return Command::SUCCESS;
    }
}
