<?php

namespace FirstpointCh\Shop\Commands;

use FirstpointCh\Shop\Models\Channel;
use Illuminate\Console\Command;

class InstallShop extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'shop:install';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install Shop';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->call('vendor:publish', ['--tag' => 'shop']);

        $this->call('migrate');
        $this->call('vendor:publish', ['--tag' => 'shop-assets', '--force']);

        if ($this->confirm('Do you want to create an admin user ?', true)) {
            $name = $this->ask('What\'s the admin name ?');
            $email = $this->ask('What\'s the admin email ?');
            $password = $this->secret('What\'s the admin password ?');

            $provider = config('auth.guards.'.config('shop.cp.guard').'.provider');
            $model = config('auth.providers.'.$provider.'.model');

            $model::create([
                'name' => $name,
                'email' => $email,
                'password' => bcrypt($password),
            ]);
        }

        if ($this->confirm('Do you want to create a default channel ?', true)) {
            $currency = str($this->ask('What\'s the default currency ?', 'CHF'))->upper();
            $country = str($this->ask('What\'s the default country (2 characters) ?', 'CH'))->upper();
            $currencyFormat = $this->ask('What currency format to use ?', 'de_CH');

            Channel::create([
                'name' => 'Default',
                'slug' => 'default',
                'currency' => $currency,
                'available_countries' => [$country],
                'currency_format' => $currencyFormat,
            ]);
        }

        $this->alert('Shop installed successfully.');
        $this->info('Front: ' . url('/'));
        $this->info('Cp: ' . url(config('shop.cp.base_url')));

        return Command::SUCCESS;
    }
}
