<?php

use FirstpointCh\Shop\Http\Controllers\Cp;
use FirstpointCh\Shop\Http\Middleware\Authenticate;
use FirstpointCh\Shop\Http\Middleware\RedirectIfAuthenticated;
use Illuminate\Support\Facades\Route;

Route::prefix(config('shop.cp.base_url'))
    ->middleware([
        'web',
        \FirstpointCh\Shop\Http\Middleware\HandleInertiaRequests::class,
    ])
    ->group(function () {
        Route::middleware(RedirectIfAuthenticated::class.':'.config('shop.cp.guard'))->group(function () {
            Route::get('/login', [Cp\Auth\AuthenticatedSessionController::class, 'create'])->name('cp.login');
            Route::post('/login', [Cp\Auth\AuthenticatedSessionController::class, 'store']);
            // Route::get('/forgot-password', [Cp\Auth\PasswordResetLinkController::class, 'create'])->name('password.request');
            // Route::post('/forgot-password', [Cp\Auth\PasswordResetLinkController::class, 'store'])->name('password.email');
            // Route::get('/reset-password/{token}', [Cp\Auth\NewPasswordController::class, 'create'])->name('password.reset');
            // Route::post('/reset-password', [Cp\Auth\NewPasswordController::class, 'store'])->name('password.update');
        });

        Route::middleware(Authenticate::class.':'.config('shop.cp.guard'))->group(function () {
            Route::post('/logout', [Cp\Auth\AuthenticatedSessionController::class, 'destroy']);

            Route::get('/', Cp\DashboardController::class);

            Route::get('/categories', Cp\CategoryController::class.'@index');
            Route::get('/categories/create', Cp\CategoryController::class.'@create');
            Route::post('/categories', Cp\CategoryController::class.'@store');
            Route::get('/categories/{category}/edit', Cp\CategoryController::class.'@edit');
            Route::post('/categories/{category}', Cp\CategoryController::class.'@update');

            Route::get('/products', Cp\ProductController::class.'@index');
            Route::get('/products/create', Cp\ProductController::class.'@create');
            Route::post('/products', Cp\ProductController::class.'@store');
            Route::get('/products/{product}/edit', Cp\ProductController::class.'@edit');
            Route::post('/products/{product}', Cp\ProductController::class.'@update');
            Route::post('/products/{product}/update-status', Cp\ProductController::class.'@updateStatus');
            Route::delete('/products/{product}', Cp\ProductController::class.'@delete');

            Route::get('/products/{product}/variants/create', Cp\ProductVariantController::class.'@create');
            Route::post('/products/{product}/variants', Cp\ProductVariantController::class.'@store');
            Route::get('/products/{product}/variants/{variant}/edit', Cp\ProductVariantController::class.'@edit');
            Route::post('/products/{product}/variants/{variant}', Cp\ProductVariantController::class.'@update');

            Route::get('/products/{product}/{tab?}', Cp\ProductController::class.'@show')
                ->name('cp.products.show')
                ->where('tab', '(variants|photos|taxes)');

            // Route::get('/products/{product}/media', Cp\ProductMediaController::class.'@index');
            Route::post('/products/{product}/media', Cp\ProductMediaController::class.'@store');
            Route::post('/products/{product}/media/{media}', Cp\ProductMediaController::class.'@update');
            Route::delete('/products/{product}/media/{media}', Cp\ProductMediaController::class.'@destroy');

            Route::get('/attributes', Cp\AttributeController::class.'@index');
            Route::get('/attributes/create', Cp\AttributeController::class.'@create');
            Route::post('/attributes', Cp\AttributeController::class.'@store');
            Route::get('/attributes/{attribute}/edit', Cp\AttributeController::class.'@edit');
            Route::post('/attributes/{attribute}', Cp\AttributeController::class.'@update');

            Route::get('/coupons', Cp\CouponController::class.'@index');
            Route::get('/coupons/create', Cp\CouponController::class.'@create');
            Route::post('/coupons', Cp\CouponController::class.'@store');
            Route::get('/coupons/{coupon}/edit', Cp\CouponController::class.'@edit');
            Route::post('/coupons/{coupon}', Cp\CouponController::class.'@update');

            Route::get('/customers', Cp\CustomerController::class.'@index');
            Route::get('/customers/create', Cp\CustomerController::class.'@create');
            Route::post('/customers', Cp\CustomerController::class.'@store');
            Route::get('/customers/{customer}/edit', Cp\CustomerController::class.'@edit');
            Route::get('/customers/{customer}/{tab?}', Cp\CustomerController::class.'@show');
            Route::post('/customers/{customer}', Cp\CustomerController::class.'@update');
            Route::get('/customers/{customer}/notifications/{notification}', Cp\CustomerNotificationController::class.'@show');

            Route::get('/orders', Cp\OrderController::class.'@index');
            Route::get('/orders/{order}', Cp\OrderController::class.'@show');
            Route::post('/orders/{order}', Cp\OrderController::class.'@update');
            Route::post('/orders/{order}/activities', Cp\OrderActivityController::class.'@store');
            Route::post('/orders/{order}/shipments', Cp\OrderShipmentController::class.'@store');
            Route::get('/orders/{order}/shipments/{shipment}/print', Cp\OrderShipmentController::class.'@print');
            Route::delete('/orders/{order}/shipments/{shipment}', Cp\OrderShipmentController::class.'@destroy');

            Route::get('/payments/{payment}/invoice', Cp\PaymentInvoiceController::class.'@show');

            Route::get('/channels', Cp\ChannelController::class.'@index');
            Route::get('/channels/create', Cp\ChannelController::class.'@create');
            Route::post('/channels', Cp\ChannelController::class.'@store');
            Route::get('/channels/{channel}/edit', Cp\ChannelController::class.'@edit');
            Route::post('/channels/{channel}', Cp\ChannelController::class.'@update');

            Route::get('/tax-rules', Cp\TaxRuleController::class.'@index');
            Route::get('/tax-rules/create', Cp\TaxRuleController::class.'@create');
            Route::post('/tax-rules', Cp\TaxRuleController::class.'@store');
            Route::get('/tax-rules/{taxRule}/edit', Cp\TaxRuleController::class.'@edit');
            Route::post('/tax-rules/{taxRule}', Cp\TaxRuleController::class.'@update');
            Route::delete('/tax-rules/{taxRule}', Cp\TaxRuleController::class.'@destroy');

            Route::get('/shipping-methods', Cp\ShippingMethodController::class.'@index');
            Route::get('/shipping-methods/create', Cp\ShippingMethodController::class.'@create');
            Route::post('/shipping-methods', Cp\ShippingMethodController::class.'@store');
            Route::get('/shipping-methods/{shippingMethod}/edit', Cp\ShippingMethodController::class.'@edit');
            Route::post('/shipping-methods/{shippingMethod}', Cp\ShippingMethodController::class.'@update');

            Route::get('/product-types', Cp\ProductTypeController::class.'@index');
            Route::get('/product-types/create', Cp\ProductTypeController::class.'@create');
            Route::post('/product-types', Cp\ProductTypeController::class.'@store');
            Route::get('/product-types/{productType}/edit', Cp\ProductTypeController::class.'@edit');
            Route::post('/product-types/{productType}', Cp\ProductTypeController::class.'@update');

            Route::get('/users', Cp\UserController::class.'@index');
            Route::get('/users/create', Cp\UserController::class.'@create');
            Route::post('/users', Cp\UserController::class.'@store');
            Route::get('/users/{user}/edit', Cp\UserController::class.'@edit');
            Route::post('/users/{user}', Cp\UserController::class.'@update');

            Route::get('/carts/{cart}', Cp\CartController::class.'@show');

            Route::get('/inventory', Cp\InventoryController::class.'@index');

            Route::post('/upload', Cp\UploadController::class.'@store');
        });
    });
