import { createApp, h } from 'vue'
import { createInertiaApp, Link } from '@inertiajs/inertia-vue3'
import { InertiaProgress } from '@inertiajs/progress'
import { resolvePageComponent } from 'laravel-vite-plugin/inertia-helpers';
import Layout from '@/Shared/Layout.vue'
import Page from '@/Shared/Page.vue';

class Shop {
    constructor() {
        this.pages = {}
    }

    boot(app) {
        for (const page in this.pages) {
            app.component(page, this.pages[page])
        }
    }

    registerPage(name, page) {
        this.pages[name] = page
    }

    start() {
        createInertiaApp({
            resolve: name => {
                let page

                if (!! this.pages[name]) {
                    page = resolvePageComponent(name, this.pages)

                    page.then((page) => {
                        page.layout = page.layout || Layout;
                    })

                    return page
                } else {
                    page = resolvePageComponent(`./Pages/${name}.vue`, import.meta.glob('./Pages/**/*.vue'))

                    page.then((module) => {
                        module.default.name = name;
                        module.default.layout = module.default.layout || Layout;
                    })
                }

                return page
            },

            setup({ el, App, props, plugin }) {
                const app = createApp({ render: () => h(App, props) })
                    .use(plugin)
                    .component('Page', Page)
                    .component('Link', Link)

                window.Shop.boot(app)

                app.mount(el)
            },
        })
    }
}

InertiaProgress.init({ color: '#3730a3' });

window.Shop = new Shop();
