<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->id();
            $table->translatable('name');
            $table->string('code');
            $table->dateTime('active_from')->nullable();
            $table->dateTime('active_to')->nullable();
            $table->string('type'); // 'fixed_amount', 'percentage'
            $table->decimal('value', 10, 2);
            $table->integer('usage_limit')->nullable();
            $table->integer('current_usage')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cart_taxes');
    }
};
