<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email');
            $table->string('company')->nullable();
            $table->string('street');
            $table->string('street_number');
            $table->string('zip');
            $table->string('city');
            $table->char('country', 2);

            $table->boolean('use_billing_address');
            $table->string('billing_company')->nullable();
            $table->string('billing_street')->nullable();
            $table->string('billing_street_number')->nullable();
            $table->string('billing_zip')->nullable();
            $table->string('billing_city')->nullable();
            $table->char('billing_country', 2)->nullable();

            $table->string('shipping_method');
            $table->string('payment_method');

            $table->decimal('shipping_price')->nullable();

            $table->decimal('amount');
            $table->char('currency', 3);
            $table->string('status');
            $table->dateTime('paid_at')->nullable();

            $table->foreignId('customer_id')->constrained();
            $table->foreignId('channel_id')->constrained();

            $table->timestamps();
        });
    }
};
