<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->translatable('name');
            $table->translatable('short_description')->nullable();
            $table->translatable('description')->nullable();
            $table->string('status')->default('draft');
            $table->foreignId('product_type_id')->nullable()->constrained()->onDelete('SET NULL');

            $table->timestamps();
        });
    }
};
