<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Models\TaxRule;
use Illuminate\Database\Eloquent\Factories\Factory;

class TaxRuleFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = TaxRule::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->word,
            'description' => $this->faker->sentence(),
            'rate' => $this->faker->numberBetween(1, 90),
            'tax_included' => $this->faker->boolean,
            'apply_to_all_channels' => true,
            'apply_to_all_product_types' => true,
        ];
    }
}
