<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Models\Customer;
use Illuminate\Database\Eloquent\Factories\Factory;

class CustomerFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Customer::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'first_name' => $this->faker->firstName(),
            'last_name' => $this->faker->lastName(),
            'email' => $this->faker->unique()->email,
            // 'default_address_id' => function () {
            //     return Address::factory()->create();
            // },
            'email_verified_at' => now(),
            'password' => bcrypt('password'),
        ];
    }
}
