<?php

namespace FirstpointCh\Shop\Tests;

use FirstpointCh\Shop\ShopServiceProvider;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Schema;
use Orchestra\Testbench\TestCase as Orchestra;

class TestCase extends Orchestra
{
    protected function setUp(): void
    {
        parent::setUp();

        Factory::guessFactoryNamesUsing(
            fn (string $modelName) => 'FirstpointCh\\Shop\\Database\\Factories\\'.class_basename($modelName).'Factory',
        );
    }

    protected function getPackageProviders($app)
    {
        return [
            \Inertia\ServiceProvider::class,
            \Spatie\LaravelData\LaravelDataServiceProvider::class,
            ShopServiceProvider::class,
        ];
    }

    public function getEnvironmentSetUp($app)
    {
        // Modifier la package eloquent translatable pour qu'il load la macro dans la fonction register plutot que boot
        // Ensuite on peut ajouter le service provider dans getPackageProviders
        Blueprint::macro('translatable', function ($column) {
            /** @var Blueprint $this */
            return $this->json($column);
        });

        config()->set('database.default', 'sqlite');
        config()->set('auth', include __DIR__.'/config/auth.php');
        config()->set('shop', include __DIR__.'/config/shop.php');
        config()->set('inertia.testing.page_paths', [
            __DIR__.'/../resources/js/Pages',
        ]);

        config()->set('media-library', include __DIR__.'/../vendor/spatie/laravel-medialibrary/config/media-library.php');

        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();
        });

        Schema::create('media', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->morphs('model');
            $table->uuid('uuid')->nullable()->unique();
            $table->string('collection_name');
            $table->string('name');
            $table->string('file_name');
            $table->string('mime_type')->nullable();
            $table->string('disk');
            $table->string('conversions_disk')->nullable();
            $table->unsignedBigInteger('size');
            $table->json('manipulations');
            $table->json('custom_properties');
            $table->json('generated_conversions');
            $table->json('responsive_images');
            $table->unsignedInteger('order_column')->nullable()->index();

            $table->nullableTimestamps();
        });

        // Loop over each files in the database folder and migrate them
        foreach (File::allFiles(__DIR__.'/../database/migrations') as $file) {
            $migration = include $file->getPathName();
            $migration->up();
        }
    }
}
