<?php

use FirstpointCh\Shop\Models\Region;
use Inertia\Testing\AssertableInertia;

it('shows the region index', function () {
    defaultRegion()->delete();

    $region = Region::factory()->create();

    $this->get('/cp/regions')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Region/Index')
            ->has('regions.data', 1)
            ->where('regions.data.0.id', $region->id)
        );
});

it('searches regions by name', function () {
    $firstRegion = Region::factory()->create([
        'name' => 'First region',
    ]);

    $secondRegion = Region::factory()->create([
        'name' => 'Second region',
    ]);

    datatableSearch('/cp/regions', 'First region')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Region/Index')
            ->has('regions.data', 1)
            ->where('regions.data.0.id', $firstRegion->id)
        );

    datatableSearch('/cp/regions', 'Second region')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Region/Index')
            ->has('regions.data', 1)
            ->where('regions.data.0.id', $secondRegion->id)
        );

    datatableSearch('/cp/regions', 'region')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Region/Index')
            ->has('regions.data', 2)
        );
});
