<?php

use Inertia\Testing\AssertableInertia;

it('shows the region create form', function () {
    $this->get('/cp/regions/create')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Region/Form')
        );
});

test('the name is required', function () {
    $this->post('/cp/regions')->assertStatus(302)->assertSessionHasErrors('name');
});

test('the slug is required', function () {
    $this->post('/cp/regions')->assertStatus(302)->assertSessionHasErrors('slug');
});

test('the currency_format is required', function () {
    $this->post('/cp/regions')->assertStatus(302)->assertSessionHasErrors('currency_format');
});

test('the currency is required and must have a length of 3 chars', function () {
    $this->post('/cp/regions')->assertStatus(302)->assertSessionHasErrors('currency');
    $this->post('/cp/regions', ['currency' => 'test'])->assertStatus(302)->assertSessionHasErrors('currency');
    $this->post('/cp/regions', ['currency' => 'tes'])->assertStatus(302)->assertSessionDoesntHaveErrors('currency');
});

test('available countries is required', function () {
    $this->post('/cp/regions')->assertStatus(302)->assertSessionHasErrors('available_countries');
});

test('each available country must have a length of 2 chars', function () {
    $this->post('/cp/regions', [
        'available_countries' => ['abc', 'de'],
    ])
    ->assertStatus(302)
    ->assertSessionHasErrors('available_countries.0')
    ->assertSessionDoesntHaveErrors('available_countries.1');
});

it('stores a new region', function () {
    $data = [
        'name' => 'My region',
        'slug' => 'my-region',
        'currency' => 'CHF',
        'currency_format' => 'de_CH',
        'available_countries' => ['CH', 'FR'],
    ];

    $this->post('/cp/regions', $data)
        ->assertStatus(302)
        ->assertRedirect('/cp/regions');

    $data['available_countries'] = json_encode($data['available_countries']);

    $this->assertDatabaseHas('regions', $data);
});
