<?php

namespace FirstpointCh\Shop;

use NumberFormatter;

class Money
{
    protected $money;

    public function __construct(
        protected string $currency,
        protected string $currencyFormat,
    ) {
        $this->money = new NumberFormatter($this->currencyFormat, NumberFormatter::CURRENCY);
    }

    public function setFormat(string $currency = null, string $currencyFormat = null)
    {
        $this->currency = $currency ?? $this->currency;
        $this->currencyFormat = $currencyFormat ?? $this->currencyFormat;

        $this->money = new NumberFormatter($this->currencyFormat, NumberFormatter::CURRENCY);

        return $this;
    }

    public function format(float $amount): string
    {
        return $this->money->formatCurrency($amount, $this->currency);
    }
}
