<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Collections\OrderItemsCollection;
use FirstpointCh\Shop\Traits\HasPackageFactory;
use Illuminate\Database\Eloquent\Model;

class OrderItem extends Model
{
    use HasPackageFactory;

    protected $guarded = [];

    protected $casts = [
        'unit_price' => 'decimal:2',
    ];

    protected $appends = ['price', 'price_formatted'];

    public function newCollection(array $models = [])
    {
        return new OrderItemsCollection($models);
    }

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function variant()
    {
        return $this->belongsTo(Variant::class, 'reference', 'reference');
    }

    public function getPriceAttribute()
    {
        return $this->unit_price * $this->quantity;
    }

    public function getPriceFormattedAttribute()
    {
        return money()->format($this->price);
    }
}
