<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Traits\HasPackageFactory;
use FirstpointCh\Translatable\Casts\Localized;
use FirstpointCh\Translatable\Traits\Translatable;
use Illuminate\Database\Eloquent\Model;

class CustomField extends Model
{
    use HasPackageFactory, Translatable;

    protected $guarded = [];

    protected $casts = [
        'name' => Localized::class,
        'translatable' => 'boolean',
    ];

    protected $appends = [
        'field',
    ];

    public function getFieldAttribute()
    {
        return shop()->getFieldTypes()->filter(function ($field) {
            return $field['component'] === $this->type;
        })->first();
    }
}
