<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use Illuminate\Support\Str;
use FirstpointCh\Shop\Http\Controllers\Controller;

class UploadController extends Controller
{
    public function store()
    {
        $data = request()->validate([
            'files' => 'required|array',
            'files.*' => 'required|file|mimes:jpeg,png,jpg,gif,svg|max:4096',
        ]);

        $paths = [];

        foreach ($data['files'] as $file) {
            $paths[] = $file->store('/', config('shop.media.cms_assets.disk'));
        }

        return $paths;
    }

    public function storeFile()
    {
        $data = request()->validate([
            'files' => 'required|array',
            'files.*' => 'required|file|max:10000',
        ]);

        $paths = [];

        foreach ($data['files'] as $file) {
            $paths[] = $file->storeAs(
                config('shop.media.documents.base_path'),
                Str::uuid() . '.' . $file->getClientOriginalExtension(),
                config('shop.media.documents.disk')
            );
        }

        return $paths;
    }
}
