<?php

namespace FirstpointCh\Shop\FieldTypes;

use Storage;

class File extends FieldType
{
    public string $component = 'file-field';

    public bool $translatable = true;

    public function getLabel(): string
    {
        return __('File(s)');
    }

    public function props()
    {
        return [
            'baseUrl' => Storage::disk(config('shop.media.documents.disk'))
                ->url(''),
        ];
    }
}
