<?php

namespace FirstpointCh\Shop\Attribute;

use FirstpointCh\Shop\Models\AttributeOption;
use Illuminate\Contracts\Support\Arrayable;

class AttributeValue implements Arrayable
{
    public function __construct(
        public $value,
        public $type,
        public $translatable,
    ) {
        //
    }

    public function __toString()
    {
        if (empty($this->value)) {
            return '';
        }

        $value = $this->translatable
            ? $this->value[app()->getLocale()] ?? $this->value[config('app.fallback_locale')]
            : $this->value;

        return match ($this->type) {
            'options' => AttributeOption::find($value)?->value,
            default => $value,
        };
    }

    public function toArray()
    {
        if (empty($this->value)) {
            return null;
        }

        $value = $this->translatable
            ? $this->value[app()->getLocale()] ?? $this->value[config('app.fallback_locale')]
            : $this->value;

        return match ($this->type) {
            'options' => AttributeOption::find($value)?->value,
            default => $value,
        };
    }

    public function raw()
    {
        if (!empty($this->value)) {
            return $this->value;
        }

        if ($this->translatable) {
            return [config('app.fallback_locale') => null];
        }

        return null;
    }
}
