<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_activities', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('CASCADE');
            $table->string('user_name');
            $table->string('action_type');
            $table->string('action_title');
            $table->text('message')->nullable();
            $table->timestamps();
        });
    }
};
