<?php

namespace FirstpointCh\LunarSwisspost\Console;

use Illuminate\Console\Command;

class InstallCommand extends Command
{
    protected $signature = 'lunar-swisspost:install';

    protected $description = 'Install the Lunar SwissPost package';

    public function handle()
    {
        $this->info('Installing Lunar SwissPost...');

        $this->info('Publishing configuration...');
        $this->call('vendor:publish', [
            '--tag' => 'lunar-swisspost-config',
        ]);

        $this->info('Publishing migrations...');
        $this->call('vendor:publish', [
            '--tag' => 'lunar-swisspost-migrations',
        ]);

        $this->info('Publishing views...');
        $this->call('vendor:publish', [
            '--tag' => 'lunar-swisspost-views',
        ]);

        $this->info('Publishing translations...');
        $this->call('vendor:publish', [
            '--tag' => 'lunar-swisspost-translations',
        ]);

        $this->info('Running migrations...');
        $this->call('migrate');

        $this->info('Lunar SwissPost installed successfully.');
    }
}