# Changelog

## [2.0.0] - 2024-10-13

### Added

- **Multiple Tracking Numbers Support**: Orders can now have multiple tracking numbers/shipping labels
  - New `lunar_order_tracking_numbers` table to store multiple tracking numbers per order
  - New `OrderTrackingNumber` model with relationships to orders
  - Added "Number of labels" field in dispatch form (1-10 labels per order)
  - All tracking numbers are displayed on the order detail page with their respective metadata

- **Enhanced Tracking Information**: Each tracking number now stores:
  - Tracking number and URL
  - Shipping method (pri/eco/aplus)
  - Delivery options (przl)
  - Creation timestamp

- **Improved UI/UX**:
  - RepeatableEntry display for multiple tracking numbers in order details
  - Legacy tracking number fields still shown for backwards compatibility
  - Enhanced notifications showing exact count of labels generated
  - Error handling for partial label generation failures

- **Bulk Action Enhancement**:
  - Bulk dispatch action now supports generating multiple labels per order
  - "Number of labels per order" field added to bulk action form

### Changed

- `ManageOrderExtension`: Updated to handle multiple label generation
- `GenerateBarcodesBulkAction`: Enhanced to support multiple labels per order
- `GeneratesBarcodes` trait: Added `generateBarcodesForOrder()` method for batch generation
- Legacy `tracking_number` and `tracking_url` columns on orders table maintained for backwards compatibility

### Migration

A new migration has been added: `2024_10_13_000000_create_order_tracking_numbers_table.php`

This migration will:
1. Create the new `lunar_order_tracking_numbers` table
2. Automatically migrate existing tracking numbers from the `lunar_orders` table to the new table
3. Preserve all existing tracking data

Run migrations after updating:
```bash
php artisan migrate
```

**Note**: The migration automatically handles existing tracking numbers, so no data will be lost. The legacy columns (`tracking_number`, `tracking_url`) on the orders table will remain for backwards compatibility.

### Backwards Compatibility

- Legacy tracking fields (`$order->tracking_number`, `$order->tracking_url`) still work
- When multiple labels are generated, the first tracking number is stored in legacy fields
- Existing tracking numbers are automatically migrated to the new table
- Existing data and functionality remain intact

