<?php

namespace FirstpointCh\LunarSwisspost\Traits;

use FirstpointCh\LunarSwisspost\Http\Barcode\Builder\BarcodeBuilder;
use Lunar\Models\Order;

trait GeneratesBarcodes
{
    protected function generateBarcodeForOrder(Order $order, array $data)
    {
        $shippingAddress = $order->shippingAddress;

		$layout = config('swisspost.layout');

        $result = BarcodeBuilder::build()
            ->customer(
                config('swisspost.customer.name1'),
                config('swisspost.customer.street'),
                config('swisspost.customer.zip'),
                config('swisspost.customer.city'),
                config('swisspost.customer.name2'),
                config('swisspost.customer.country')
            )
            ->recipient(
                $shippingAddress->first_name . ' ' . $shippingAddress->last_name,
                $shippingAddress->city,
                $shippingAddress->line_one,
                $shippingAddress->postcode,
                null, // title
                null,
                $shippingAddress->company_name,
                $shippingAddress->line_two,
                $shippingAddress->line_three,
                null, // houseNo
                $shippingAddress->country->iso2
            )
            ->layout($layout === 'a4' ? config('swisspost.packing_slip_label_format') : $layout)
            ->przl(array_merge([$data['method']], $data['przl']))
            ->create();

        return [
			'errors' => $result->getErrors(),
            'base64' => $result->getLabel(),
            'tracking_number' => $result->getTrackingNumber(),
            'tracking_url' => $result->getTrackingUrl(),
        ];
    }

    protected function generateBarcodesForOrder(Order $order, array $data, int $quantity = 1): array
    {
        $results = [];

        for ($i = 0; $i < $quantity; $i++) {
            $results[] = $this->generateBarcodeForOrder($order, $data);
        }

        return $results;
    }

    protected function getBarcodeFormSchema(): array
    {
        return [
            \Filament\Forms\Components\Select::make('method')
                ->label(__('Shipping method'))
                ->options([
                    'pri' => __('Prioritaire'),
                    'eco' => __('Économique'),
					'aplus' => __('A+')
                ])
                ->default('eco')
                ->required(),

            \Filament\Forms\Components\CheckboxList::make('przl')
                ->label(__('Delivery options'))
                ->options([
                    'si' => __('Signature')
                ])
                ->columns(2),
        ];
    }
}
