<?php

namespace FirstpointCh\LunarSwisspost\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Lunar\Models\Order;

class OrderTrackingNumber extends Model
{
    protected $table = 'lunar_order_tracking_numbers';

    protected $fillable = [
        'order_id',
        'tracking_number',
        'tracking_url',
        'method',
        'przl',
    ];

    protected $casts = [
        'przl' => 'array',
    ];

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }
}

