<?php

namespace FirstpointCh\LunarSwisspost\Http\Barcode;

use GuzzleHttp\Client;
use FirstpointCh\LunarSwisspost\Http\Auth\Authenticator;
use FirstpointCh\LunarSwisspost\Http\Barcode\Builder\BarcodeBuilder;

class BarcodeClient
{
    protected $client;
    protected $authenticator;
    protected $baseUrl;

    public function __construct(Authenticator $authenticator)
    {
        $this->client = new Client();
        $this->authenticator = $authenticator;
        $this->baseUrl = config('swisspost.base_url');
    }

	public function generateBarcode()
    {
        return new BarcodeBuilder($this);
    }

    /**
     * Execute the barcode generation with given parameters.
     *
     * @param array $params
     * @return array
     */
    public function executeGenerateBarcode(array $params)
    {
		try {
			$response = $this->client->post($this->baseUrl . '/barcode/v1/generateAddressLabel', [
				'headers' => [
					'Authorization' => 'Bearer ' . $this->authenticator->getAccessToken(),
					'Accept' => 'application/json',
					'Content-Type' => 'application/json',
				],
				'json' => $params
			]);

			$formattedResponse = json_decode($response->getBody(), true);

			if ($response->getStatusCode() !== 200) {
				return [
					'errors' => $formattedResponse['errors']
				];
			}

			return $formattedResponse['item'];
		} catch (\Exception $e) {
			return [
				'errors' => $e->getMessage()
			];
		}
    }
}
