<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        Schema::create('lunar_order_tracking_numbers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained('lunar_orders')->onDelete('cascade');
            $table->string('tracking_number');
            $table->string('tracking_url')->nullable();
            $table->string('method')->nullable();
            $table->json('przl')->nullable();
            $table->timestamps();
        });

        $this->migrateExistingTrackingNumbers();
    }

    protected function migrateExistingTrackingNumbers()
    {
        $orders = DB::table('lunar_orders')
            ->whereNotNull('tracking_number')
            ->where('tracking_number', '!=', '')
            ->get(['id', 'tracking_number', 'tracking_url', 'created_at', 'updated_at']);

        foreach ($orders as $order) {
            DB::table('lunar_order_tracking_numbers')->insert([
                'order_id' => $order->id,
                'tracking_number' => $order->tracking_number,
                'tracking_url' => $order->tracking_url,
                'method' => null,
                'przl' => null,
                'created_at' => $order->updated_at ?? $order->created_at,
                'updated_at' => $order->updated_at ?? $order->created_at,
            ]);
        }
    }

    public function down()
    {
        Schema::dropIfExists('lunar_order_tracking_numbers');
    }
};

