lunar-swisspost/tests/Unit/Console/InstallCommandTest.php
<?php
use FirstpointCh\LunarSwisspost\Console\InstallCommand;
use Illuminate\Support\Facades\Artisan;

it("has correct signature", function () {
    $command = new InstallCommand();

    expect($command->getName())->toBe("lunar-swisspost:install");
});

it("has correct description", function () {
    $command = new InstallCommand();

    expect($command->getDescription())->toBe(
        "Install the Lunar SwissPost package",
    );
});

it("publishes configuration when run", function () {
    // Mock the command to verify it calls vendor:publish with correct tag
    $command = Mockery::mock(InstallCommand::class)
        ->makePartial()
        ->shouldAllowMockingProtectedMethods();

    $command
        ->shouldReceive("call")
        ->with("vendor:publish", ["--tag" => "lunar-swisspost-config"])
        ->once();

    $command
        ->shouldReceive("call")
        ->with("vendor:publish", ["--tag" => "lunar-swisspost-migrations"])
        ->once();

    $command
        ->shouldReceive("call")
        ->with("vendor:publish", ["--tag" => "lunar-swisspost-views"])
        ->once();

    $command
        ->shouldReceive("call")
        ->with("vendor:publish", ["--tag" => "lunar-swisspost-translations"])
        ->once();

    $command->shouldReceive("call")->with("migrate")->once();

    $command->shouldReceive("info")->andReturnNull();

    $command->handle();
})->skip("Requires full Laravel application context");

it("outputs installation messages", function () {
    // Verify the command outputs expected messages
    $command = new InstallCommand();

    expect($command->getName())->toBe("lunar-swisspost:install");
})->skip("Requires full Laravel application context");

afterEach(function () {
    Mockery::close();
});

