<?php

use Illuminate\Support\Facades\Config;

beforeEach(function () {
    Config::set("swisspost.client_id", "test-client-id");
    Config::set("swisspost.client_secret", "test-client-secret");
    Config::set("swisspost.parcel_license", "test-parcel-license");
    Config::set("swisspost.letter_license", "test-letter-license");
    Config::set("swisspost.base_url", "https://test-api.apis.post.ch");
    Config::set("swisspost.customer", [
        "name1" => "Test Company",
        "street" => "Test Street 1",
        "zip" => "1000",
        "city" => "Lausanne",
        "country" => "CH",
    ]);
    Config::set("swisspost.layout", "a5");
    Config::set("swisspost.packing_slip_label_format", "a6");
});

it("has client_id configuration", function () {
    expect(config("swisspost.client_id"))->toBe("test-client-id");
});

it("has client_secret configuration", function () {
    expect(config("swisspost.client_secret"))->toBe("test-client-secret");
});

it("has parcel_license configuration", function () {
    expect(config("swisspost.parcel_license"))->toBe("test-parcel-license");
});

it("has letter_license configuration", function () {
    expect(config("swisspost.letter_license"))->toBe("test-letter-license");
});

it("has base_url configuration", function () {
    expect(config("swisspost.base_url"))->toBe("https://test-api.apis.post.ch");
});

it("has customer configuration with all required fields", function () {
    $customer = config("swisspost.customer");

    expect($customer)->toHaveKeys([
        "name1",
        "street",
        "zip",
        "city",
        "country",
    ]);
    expect($customer["name1"])->toBe("Test Company");
    expect($customer["street"])->toBe("Test Street 1");
    expect($customer["zip"])->toBe("1000");
    expect($customer["city"])->toBe("Lausanne");
    expect($customer["country"])->toBe("CH");
});

it("has layout configuration", function () {
    expect(config("swisspost.layout"))->toBe("a5");
});

it("has packing_slip_label_format configuration", function () {
    expect(config("swisspost.packing_slip_label_format"))->toBe("a6");
});

it("has default values for post_label_status", function () {
    expect(config("swisspost.post_label_status"))->toBeNull();
});

it("has default value for packing_slip_logo", function () {
    expect(config("swisspost.packing_slip_logo"))->toBeNull();
});

it("has default value for post_label_notification", function () {
    expect(config("swisspost.post_label_notification"))->toBeNull();
});
