lunar-swisspost/tests/Pest.php
<?php
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\TestCase as BaseTestCase;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;
use Orchestra\Testbench\Concerns\CreatesApplication;

abstract class TestCase extends BaseTestCase
{
    use CreatesApplication;

    protected function getPackageProviders($app): array
    {
        return [];
    }

    protected function defineEnvironment($app): void
    {
        $app["config"]->set("database.default", "testing");
        $app["config"]->set("database.connections.testing", [
            "driver" => "sqlite",
            "database" => ":memory:",
            "prefix" => "",
        ]);
        $app["config"]->set(
            "app.key",
            "base64:" . base64_encode(random_bytes(32)),
        );
    }

    protected function setUp(): void
    {
        parent::setUp();

        // Create the tracking numbers table for testing
        if (!Schema::hasTable("lunar_order_tracking_numbers")) {
            Schema::create("lunar_order_tracking_numbers", function ($table) {
                $table->id();
                $table->string("tracking_number");
                $table->string("label_path")->nullable();
                $table->json("przl")->nullable();
                $table->unsignedBigInteger("order_id")->nullable();
                $table->timestamps();
            });
        }

        // Define routes for testing
        Route::middleware(["web"])
            ->name("lunar-swisspost.")
            ->prefix("lunar-swisspost")
            ->group(function () {
                Route::get(
                    "tracking-numbers/{trackingNumber}/label",
                    \FirstpointCh\LunarSwisspost\Http\Controllers\DownloadLabelController::class,
                )->name("labels.download");
            });
    }
}

uses(TestCase::class, RefreshDatabase::class)->in("Feature", "Unit");

expect()->extend("toBeOne", function () {
    return $this->toBe(1);
});

function something(): void
{
    // ..
}

