<?php

namespace FirstpointCh\LunarSwisspost\Widgets;

use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Widgets\Widget;
use Filament\Forms\Form;
use FirstpointCh\LunarSwisspost\Http\Barcode\Builder\PdfBuilder;
use FirstpointCh\LunarSwisspost\Traits\GeneratesBarcodes;
use Lunar\Models\Order;

class BarcodeGeneratorWidget extends Widget implements HasForms
{
    use InteractsWithForms, GeneratesBarcodes;

    protected static string $view = 'lunar-swisspost::barcode-generator-widget';

    public ?array $data = [];
    public Order $record;
    public $trackingNumber;
    public $label;
    public $trackingUrl;
    public $errors;

    public function mount(Order $record): void
    {
        $this->record = $record;
        $this->form->fill();
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema($this->getBarcodeFormSchema())
            ->statePath('data');
    }

    public function generateBarcode()
    {
        $result = $this->generateBarcodeForOrder($this->record, $this->data);

        if (isset($result['errors'])) {
            $this->errors = $result['errors'];
            return;
        }

        $this->record->update([
            'tracking_number' => $result['tracking_number'],
            'tracking_url' => $result['tracking_url'],
        ] + (config('swisspost.post_label_status') ? ['status' => config('swisspost.post_label_status')] : []));

        $trackingNumber = $this->record->trackingNumbers()->create([
            'tracking_number' => $result['tracking_number'],
            'tracking_url' => $result['tracking_url'],
            'method' => $this->data['method'],
            'przl' => $this->data['przl'] ?? [],
        ]);
        $this->storeLabelForTrackingNumber($trackingNumber, $result['base64']);

		if (config('swisspost.post_label_notification') && $this->record->user && class_exists(config('swisspost.post_label_notification'))) {
			$notificationClass = config('swisspost.post_label_notification');
			$notification = new $notificationClass($this->record, $result);
			
			if ($this->record->user) {
				$this->record->user->notify($notification);
			}
		}
		
        return PdfBuilder::build()
			->addLabel($result['base64'], $this->record)
			->download($this->record->id . '_' . $this->record->tracking_number . '.pdf');
    }
}