<?php

namespace FirstpointCh\LunarSwisspost;

use FirstpointCh\LunarSwisspost\Extensions\ManageOrderExtension;
use FirstpointCh\LunarSwisspost\Extensions\ViewOrderExtension;
use Illuminate\Support\ServiceProvider;
use Lunar\Admin\Support\Facades\LunarPanel;
use FirstpointCh\LunarSwisspost\Widgets\BarcodeGeneratorWidget;
use Livewire\Livewire;
use FirstpointCh\LunarSwisspost\Extensions\OrderRessourceExtension;
use Lunar\Models\Order;
use FirstpointCh\LunarSwisspost\Models\OrderTrackingNumber;

class LunarSwisspostServiceProvider extends ServiceProvider
{
    public function boot()
    {
		$this->publishes([
			__DIR__.'/../resources/views/publishable' => resource_path('views/vendor/lunar-swisspost'),
		], 'lunar-swisspost-views');

		$this->publishes([
            __DIR__.'/../config/swisspost.php' => config_path('swisspost.php'),
        ], 'lunar-swisspost-config');

		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'lunar-swisspost-migrations');

		$this->loadViewsFrom(__DIR__.'/../resources/views', 'lunar-swisspost');
        $this->loadRoutesFrom(__DIR__.'/../routes/web.php');

        Order::resolveRelationUsing('trackingNumbers', function ($orderModel) {
            return $orderModel->hasMany(OrderTrackingNumber::class);
        });

        LunarPanel::extensions([
            \Lunar\Admin\Filament\Resources\OrderResource\Pages\ManageOrder::class => [ManageOrderExtension::class],
            \Lunar\Admin\Filament\Resources\OrderResource::class => OrderRessourceExtension::class,
        ]);

        Livewire::component('lunar-swisspost::barcode-generator-widget', BarcodeGeneratorWidget::class);

        $this->publishes([
            __DIR__.'/../resources/lang' => resource_path('lang/vendor/lunar-swisspost'),
        ], 'lunar-swisspost-translations');

        $this->loadJsonTranslationsFrom(__DIR__.'/../resources/lang');

		if ($this->app->runningInConsole()) {
			$this->commands([
				\FirstpointCh\LunarSwisspost\Console\InstallCommand::class,
			]);
		}
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
		$this->mergeConfigFrom(
			__DIR__.'/../config/swisspost.php', 'swisspost'
		);

		$this->app->singleton('swisspost.auth', function ($app) {
			return new \FirstpointCh\LunarSwisspost\Http\Auth\Authenticator();
		});

		$this->app->singleton('swisspost.barcode', function ($app) {
			return new \FirstpointCh\LunarSwisspost\Http\Barcode\BarcodeClient($app['swisspost.auth']);
		});
    }
}
