<?php

namespace FirstpointCh\LunarSwisspost\Http\Controllers;

use FirstpointCh\LunarSwisspost\Models\OrderTrackingNumber;
use FirstpointCh\LunarSwisspost\Http\Barcode\Builder\PdfBuilder;
use Illuminate\Support\Facades\Storage;

class DownloadPdfController
{
    public function __invoke(OrderTrackingNumber $trackingNumber)
    {
        $path = $trackingNumber->label_path;
        $img = null;

        if ($path && Storage::disk('local')->exists($path)) {
            $img = base64_encode(Storage::disk('local')->get($path));
        }

        $order = $trackingNumber->order;

        $pdf = PdfBuilder::build();
        $pdf->addLabel($img, $order);

        $filename = $order->reference;
        $filename .= '_' . $trackingNumber->tracking_number;

        return $pdf->download($filename . '.pdf');
    }
}
