<?php

namespace FirstpointCh\LunarSwisspost\Http\Controllers;

use FirstpointCh\LunarSwisspost\Models\OrderTrackingNumber;
use Illuminate\Support\Facades\Storage;

class DownloadLabelController
{
    public function __invoke(OrderTrackingNumber $trackingNumber)
    {
        $path = $trackingNumber->label_path;

        if (!$path || !Storage::disk('local')->exists($path)) {
            abort(404);
        }

        return response()->download(
            Storage::disk('local')->path($path),
            $trackingNumber->tracking_number . '.png',
            ['Content-Type' => 'image/png']
        );
    }
}

